/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.models.GLMExplorer;
import org.rosuda.deducer.models.GLMExplorerExport;
import org.rosuda.deducer.models.GLMExplorerMeans;
import org.rosuda.deducer.models.GLMModel;
import org.rosuda.deducer.models.LinearBuilder;
import org.rosuda.deducer.models.LinearDialog;
import org.rosuda.deducer.models.LinearExplorerOptions;
import org.rosuda.deducer.models.LinearExplorerPlots;
import org.rosuda.deducer.models.LinearModel;
import org.rosuda.deducer.toolkit.AssumptionIcon;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;

public class LinearExplorer
extends GLMExplorer {
    protected IconButton assumpOutlier;

    LinearExplorer(GLMModel gLMModel) {
        super(gLMModel);
        this.help.setUrl(HelpButton.baseUrl + "pmwiki.php?n=Main.LinearModel");
        this.setTitle("Linear Regression Model Explorer");
    }

    @Override
    protected void initAssumptions() {
        try {
            this.assumpN = new AssumptionIcon("/icons/N_assump.png", "Large Sample", null, "Large Sample");
            this.topPanel.add(this.assumpN);
            this.assumpN.setBounds(108, 8, 27, 27);
            this.assumpFunc = new AssumptionIcon("/icons/func_assump.png", "Correct Functional Form", null, "Correct Functional Form");
            this.topPanel.add(this.assumpFunc);
            this.assumpFunc.setBounds(44, 8, 27, 27);
            this.assumpHomo = new AssumptionIcon("/icons/eqvar_assump.png", "Equal Variance", null, "Equal Variance");
            this.topPanel.add(this.assumpHomo);
            this.assumpHomo.setBounds(76, 8, 27, 27);
            this.assumpOutlier = new AssumptionIcon("/icons/outlier_assump.png", "No Outliers", null, "No Outliers");
            this.topPanel.add(this.assumpOutlier);
            this.assumpOutlier.setBounds(12, 8, 27, 27);
            this.refreshAssumptions();
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    @Override
    public void run() {
        if (((LinearModel)this.model).hccm) {
            this.model.plots.confInt = false;
            this.model.effects.confInt = false;
        }
        this.model.run(false, this.pre);
        this.dispose();
        LinearDialog.setLastModel(this.model);
        Deducer.timedEval("suppressWarnings(rm('" + this.pre.data.split("\\$")[1] + "','" + this.pre.modelName.split("\\$")[1] + "',envir=" + Deducer.guiEnv + "))");
    }

    @Override
    public void optionsClicked() {
        LinearExplorerOptions linearExplorerOptions = new LinearExplorerOptions(this, (LinearModel)this.model);
        linearExplorerOptions.setLocationRelativeTo(this);
        linearExplorerOptions.setVisible(true);
        this.setModel(this.model);
    }

    @Override
    public void plotsClicked() {
        LinearExplorerPlots linearExplorerPlots = new LinearExplorerPlots(this, this.model, this.pre, ((LinearModel)this.model).hccm);
        linearExplorerPlots.setLocationRelativeTo(this);
        linearExplorerPlots.setVisible(true);
        this.setModel(this.model);
    }

    @Override
    public void meansClicked() {
        GLMExplorerMeans gLMExplorerMeans = new GLMExplorerMeans(this, this.model, this.pre);
        gLMExplorerMeans.setLocationRelativeTo(this);
        if (((LinearModel)this.model).hccm) {
            gLMExplorerMeans.disableConfInt();
        }
        gLMExplorerMeans.setVisible(true);
        this.setModel(this.model);
    }

    @Override
    public void exportClicked() {
        GLMExplorerExport gLMExplorerExport = new GLMExplorerExport(this, this.model);
        gLMExplorerExport.setLocationRelativeTo(this);
        gLMExplorerExport.setSinglePredicted();
        gLMExplorerExport.setVisible(true);
    }

    @Override
    public void updateClicked() {
        LinearBuilder linearBuilder = new LinearBuilder(this.model);
        linearBuilder.setLocationRelativeTo(this);
        linearBuilder.setVisible(true);
        WindowTracker.addWindow(linearBuilder);
        this.dispose();
    }

    @Override
    public void setModel(GLMModel gLMModel) {
        super.setModel(gLMModel);
        this.refreshAssumptions();
    }

    private void refreshAssumptions() {
        if (this.model != null && this.model instanceof LinearModel && this.assumpHomo != null) {
            if (((LinearModel)this.model).hccm) {
                this.assumpHomo.setVisible(false);
                this.assumpN.setSize(27, 27);
                this.assumpN.setIcon("/icons/N_assump.png");
                this.assumpN.setToolTipText("Large sample");
            } else {
                this.assumpN.setIcon("/icons/N_or_norm_assump.png");
                this.assumpN.setToolTipText("Large sample or normal residuals");
                this.assumpN.setSize(47, 27);
                this.assumpHomo.setVisible(true);
            }
        }
    }
}

