## ----setup, include=FALSE-----------------------------------------------------
library(jointCompRisk)
library(readr)
library(dplyr)
library(survival)

## -----------------------------------------------------------------------------
raw <- read.csv("main_df.csv")
long <- read.csv("long_df.csv")

## -----------------------------------------------------------------------------
# 1) Standard CIF:
mydata_std <- prep_data_cif(
  data             = raw,
  ID               = "ID",
  TimeToRecovery   = "TimeToRecovery",
  TimeToDeath      = "TimeToDeath",
  Recov_Censoring  = "RecoveryCensoringIndicator",
  Death_Censoring  = "DeathCensoringIndicator",
  Treatment        = "Treatment"
)


res_std <- do_cif_analysis(mydata_std, tau=15)
res_std$RMLT1$groups
res_std$RMLT1$contrast
res_std$RMLT2$groups
res_std$RMLT2$contrast

## -----------------------------------------------------------------------------
# Prepare weighted CIF data with updated variable names
prepped_w <- prep_data_weighted_cif(
  data_main = raw,
  data_long = long,

  wID_main              = "ID",
  wTimeToRecovery_main  = "TimeToRecovery",
  wTimeToDeath_main     = "TimeToDeath",
  wRecov_Censoring_main = "RecoveryCensoringIndicator",
  wDeath_Censoring_main = "DeathCensoringIndicator",
  wTreatment_main       = "Treatment",
  wBaselineScore_main   = "BaselineScore",
  
  wID_long              = "PersonID",
  wADY_long             = "RelativeDay",
  wScore_long           = "OrdinalScore",

  wStates_death         = c(4,5,6,7), 
  wWeights_death        = c(2,1.5,1,0.5),
  wStates_discharge     = c(4,5,6,7),
  wWeights_discharge    = c(0.5,1,1.5,2)
)

# Run Weighted CIF analysis at tau=15
res_w15 <- do_weighted_cif_analysis(prepped_w, tau=15)
res_w15$WRMLT1$groups
res_w15$WRMLT1$contrast
res_w15$WRMLT2$groups
res_w15$WRMLT2$contrast

# Run Weighted CIF analysis at tau=29
res_w29 <- do_weighted_cif_analysis(prepped_w, tau=29)
res_w29$WRMLT1$groups
res_w29$WRMLT1$contrast
res_w29$WRMLT2$groups
res_w29$WRMLT2$contrast

