/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5ACpublic_H
#define H5ACpublic_H

#include "H5public.h"  
#include "H5Cpublic.h" 

#define H5AC__CURR_CACHE_CONFIG_VERSION 1
#define H5AC__MAX_TRACE_FILE_NAME_LEN   1024

#define H5AC_METADATA_WRITE_STRATEGY__PROCESS_0_ONLY 0
#define H5AC_METADATA_WRITE_STRATEGY__DISTRIBUTED    1

//! <!-- [H5AC_cache_config_t_snip] -->
typedef struct H5AC_cache_config_t {
    
    //! <!-- [H5AC_cache_config_t_general_snip] -->
    int version;
    

    bool rpt_fcn_enabled;
    

    bool open_trace_file;
    

    bool close_trace_file;
    

    char trace_file_name[H5AC__MAX_TRACE_FILE_NAME_LEN + 1];
    

    bool evictions_enabled;
    

    bool set_initial_size;
    

    size_t initial_size;
    

    double min_clean_fraction;
    

    size_t max_size;
    

    size_t min_size;
    

    long int epoch_length;
    
    //! <!-- [H5AC_cache_config_t_general_snip] -->

    
    //! <!-- [H5AC_cache_config_t_incr_snip] -->
    enum H5C_cache_incr_mode incr_mode;
    

    double lower_hr_threshold;
    

    double increment;
    

    bool apply_max_increment;
    

    size_t max_increment;
    

    enum H5C_cache_flash_incr_mode flash_incr_mode;
    

    double flash_multiple;
    

    double flash_threshold;
    
    //! <!-- [H5AC_cache_config_t_incr_snip] -->

    
    //! <!-- [H5AC_cache_config_t_decr_snip] -->
    enum H5C_cache_decr_mode decr_mode;
    

    double upper_hr_threshold;
    

    double decrement;
    

    bool apply_max_decrement;
    

    size_t max_decrement;
    

    int epochs_before_eviction;
    

    bool apply_empty_reserve;
    

    double empty_reserve;
    
    //! <!-- [H5AC_cache_config_t_decr_snip] -->

    
    //! <!-- [H5AC_cache_config_t_parallel_snip] -->
    size_t dirty_bytes_threshold;
    

    int metadata_write_strategy;
    
    //! <!-- [H5AC_cache_config_t_parallel_snip] -->
} H5AC_cache_config_t;
//! <!-- [H5AC_cache_config_t_snip] -->

#define H5AC__CURR_CACHE_IMAGE_CONFIG_VERSION 1

#define H5AC__CACHE_IMAGE__ENTRY_AGEOUT__NONE -1

#define H5AC__CACHE_IMAGE__ENTRY_AGEOUT__MAX 100

//! <!-- [H5AC_cache_image_config_t_snip] -->

typedef struct H5AC_cache_image_config_t {
    int version;
    
    bool generate_image;
    
    bool save_resize_status;
    
    int entry_ageout;
    
} H5AC_cache_image_config_t;

//! <!-- [H5AC_cache_image_config_t_snip] -->

#endif
